/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp;

import DE.siemens.ad.logo.app.Application;
import DE.siemens.ad.logo.app.comp.BorderJPanel;
import DE.siemens.ad.logo.app.comp.DataInputPanel;
import DE.siemens.ad.logo.app.comp.EditableNumericCellSpinner;
import DE.siemens.ad.logo.dialog.comp.BlockListCellRenderer;
import DE.siemens.ad.logo.dialog.comp.IndexedJTablePanel;
import DE.siemens.ad.logo.dialog.comp.SpinnerCellEditor;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.BlockVMMappingInfo;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.ParameterItem;
import DE.siemens.ad.logo.util.BlockByNumberComparator;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoError;
import DE.siemens.ad.logo.util.ProgramException;
import DE.siemens.ad.logo.util.ValueOrItemReference;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import DE.siemens.ad.udf.UDFBlockParameter;
import DE.siemens.ad.udf.UDFParameterItem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumnModel;

public class VMConfigurePanel
extends DataInputPanel {
    private JComboBox fBlockJComboBox;
    private JComboBox fParameterJComboBox;
    private BorderJPanel fBlockMappingPanel;
    private LogoDrawing fLogoDrawing = (LogoDrawing)Application.getInstance().getActiveApplicationSurface().getEditor().getView().getModel();
    private Hardware fHardware = this.fLogoDrawing.getWiringDiagram().getHardware();
    private IndexedJTablePanel fTablePanel;
    private JTable fTable;
    private EditableNumericCellSpinner fLengthSpinner;

    public VMConfigurePanel() {
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(540, 325));
        this.setName(Language.getString("tool.vmConfigure.title", "Variable Memory Configuration"));
        this.add((Component)this.getBlockMappingPanel(), "Center");
    }

    private JComboBox getBlockComboBox() {
        if (this.fBlockJComboBox == null) {
            this.fBlockJComboBox = new JComboBox();
            this.fBlockJComboBox.setPreferredSize(new Dimension(240, 27));
            BlockListCellRenderer fBlockRenderer = new BlockListCellRenderer(true);
            fBlockRenderer.setScale(0.75f);
            this.fBlockJComboBox.setRenderer(fBlockRenderer);
            this.fBlockJComboBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1 && !VMConfigurePanel.this.fBlockJComboBox.getSelectedItem().equals(VMConfigurePanel.this.fTable.getValueAt(VMConfigurePanel.this.fTable.getSelectedRow(), VMConfigurePanel.this.getBlockColumnIndex()))) {
                        VMConfigurePanel.this.fTable.setValueAt(null, VMConfigurePanel.this.fTable.getSelectedRow(), VMConfigurePanel.this.getParameterColumnIndex());
                        VMConfigurePanel.this.fTable.setValueAt(null, VMConfigurePanel.this.fTable.getSelectedRow(), VMConfigurePanel.this.getVMTypeColumnIndex());
                        VMConfigurePanel.this.fTable.setValueAt(null, VMConfigurePanel.this.fTable.getSelectedRow(), VMConfigurePanel.this.getAddressColumnIndex());
                    }
                }
            });
        }
        LogoDrawing fLogoDrawing = (LogoDrawing)Application.getInstance().getActiveApplicationSurface().getEditor().getView().getModel();
        Enumeration blockEnum = fLogoDrawing.getWiringDiagram().getBlocks().elements();
        Vector<Block> blocks = new Vector<Block>();
        while (blockEnum.hasMoreElements()) {
            Block block = (Block)blockEnum.nextElement();
            BlockParameter blockParameter = block.getParameter();
            if (blockParameter == null || blockParameter.getParameterItems().getPublicToVMParameterItemList().isEmpty()) continue;
            blocks.addElement(block);
        }
        Collections.sort(blocks, new BlockByNumberComparator());
        DefaultComboBoxModel model = new DefaultComboBoxModel(blocks);
        this.fBlockJComboBox.setModel(model);
        return this.fBlockJComboBox;
    }

    private JComboBox getParameterComboBox() {
        if (this.fParameterJComboBox == null) {
            this.fParameterJComboBox = new JComboBox();
            this.fParameterJComboBox.setPreferredSize(new Dimension(200, 27));
            ParameterItemListCellRenderer fParameterRenderer = new ParameterItemListCellRenderer();
            fParameterRenderer.setHorizontalTextPosition(10);
            this.fParameterJComboBox.setRenderer(fParameterRenderer);
            this.fParameterJComboBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1 && VMConfigurePanel.this.fParameterJComboBox.isPopupVisible()) {
                        int clickedRow = VMConfigurePanel.this.fTable.getSelectedRow();
                        Object parameterItem = VMConfigurePanel.this.fParameterJComboBox.getSelectedItem();
                        if (!parameterItem.equals(VMConfigurePanel.this.fTable.getValueAt(clickedRow, VMConfigurePanel.this.getParameterColumnIndex()))) {
                            if (parameterItem instanceof UDFParameterItem) {
                                parameterItem = ((UDFParameterItem)parameterItem).getRootSourceParameterItem();
                            }
                            VMConfigurePanel.this.fTable.setValueAt(VMConfigurePanel.getVMTypeName(((ParameterItem)parameterItem).getLengthInVM()), clickedRow, VMConfigurePanel.this.getVMTypeColumnIndex());
                            if (VMConfigurePanel.this.fTable.getValueAt(clickedRow, VMConfigurePanel.this.getAddressColumnIndex()) == null) {
                                int address = 0;
                                if (clickedRow != 0) {
                                    address = VMConfigurePanel.this.getNextAddress(clickedRow);
                                }
                                VMConfigurePanel.this.fTable.setValueAt(address, clickedRow, VMConfigurePanel.this.getAddressColumnIndex());
                            }
                        }
                    }
                }
            });
        }
        return this.fParameterJComboBox;
    }

    private int getNextAddress(int clickedRow) {
        int currentLength;
        int previousDataLength;
        if (clickedRow == 0) {
            return 0;
        }
        int previousAddress = 0;
        if (this.fTable.getValueAt(clickedRow - 1, this.getAddressColumnIndex()) != null) {
            previousAddress = Integer.valueOf(this.fTable.getValueAt(clickedRow - 1, this.getAddressColumnIndex()).toString());
        }
        String previousVMType = "";
        if (this.fTable.getValueAt(clickedRow - 1, this.getVMTypeColumnIndex()) != null) {
            previousVMType = this.fTable.getValueAt(clickedRow - 1, this.getVMTypeColumnIndex()).toString();
        }
        if (previousAddress + (previousDataLength = VMConfigurePanel.getDataTypeLength(previousVMType)) + (currentLength = VMConfigurePanel.getDataTypeLength(this.fTable.getValueAt(clickedRow, this.getVMTypeColumnIndex()).toString())) > this.getVMSize()) {
            return 0;
        }
        return previousAddress + previousDataLength;
    }

    private BorderJPanel getBlockMappingPanel() {
        if (this.fBlockMappingPanel == null) {
            this.fBlockMappingPanel = new BorderJPanel(new GridBagLayout());
            this.fBlockMappingPanel.setTitle(Language.getString("tool.vmConfigure.mapping", "Parameter VM Mapping"));
            this.fBlockMappingPanel.setLayout(new GridLayout(1, 1));
            Object[] fColumnName = new String[]{Language.getString("dialog.parameter.message.blockBorder", "Block"), Language.getString("dialog.parameter.message.blockParameterBorder", "Parameter"), Language.getString("tool.vmConfigure.vmType", "VM Type"), Language.getString("tool.vmConfigure.address", "Address")};
            DefaultTableModel model = new DefaultTableModel(fColumnName, 0);
            ComboBoxSwitchTable comboBoxTable = new ComboBoxSwitchTable(model);
            this.fTablePanel = new IndexedJTablePanel(comboBoxTable, this.fHardware.getIntProperty("blockVMMappingNumber"));
            this.fTablePanel.setRowHeight(27);
            this.fTable = this.fTablePanel.getTable();
            this.fTable.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (VMConfigurePanel.this.fTable.columnAtPoint(e.getPoint()) == VMConfigurePanel.this.getAddressColumnIndex()) {
                        Object vmType = VMConfigurePanel.this.fTable.getValueAt(VMConfigurePanel.this.fTable.rowAtPoint(e.getPoint()), VMConfigurePanel.this.getVMTypeColumnIndex());
                        if (vmType != null) {
                            VMConfigurePanel.this.fLengthSpinner.setMax(VMConfigurePanel.this.getVMSize() - VMConfigurePanel.getDataTypeLength(vmType.toString()));
                        } else {
                            VMConfigurePanel.this.fLengthSpinner.setMax(VMConfigurePanel.this.getVMSize() - 1);
                        }
                    }
                    super.mouseClicked(e);
                }
            });
            TableColumnModel columnModel = this.fTable.getColumnModel();
            columnModel.getColumn(this.getBlockColumnIndex()).setPreferredWidth(270);
            columnModel.getColumn(this.getParameterColumnIndex()).setPreferredWidth(250);
            DefaultCellEditor parameterCellEditor = new DefaultCellEditor(this.getParameterComboBox());
            parameterCellEditor.setClickCountToStart(2);
            columnModel.getColumn(this.getParameterColumnIndex()).setCellEditor(parameterCellEditor);
            ParameterItemTableCellRenderer fParameterRenderer = new ParameterItemTableCellRenderer();
            fParameterRenderer.setHorizontalTextPosition(10);
            columnModel.getColumn(this.getParameterColumnIndex()).setCellRenderer(fParameterRenderer);
            DefaultCellEditor blockCellEditor = new DefaultCellEditor(this.getBlockComboBox());
            blockCellEditor.setClickCountToStart(2);
            BlockTableCellRenderer fBlockRenderer = new BlockTableCellRenderer(true);
            fBlockRenderer.setScale(0.75f);
            columnModel.getColumn(this.getBlockColumnIndex()).setCellEditor(blockCellEditor);
            columnModel.getColumn(this.getBlockColumnIndex()).setCellRenderer(fBlockRenderer);
            String[] data = new String[]{"Word", "DWord"};
            DefaultCellEditor typeEditor = new DefaultCellEditor(new JComboBox<String>(data)){

                public boolean isCellEditable(EventObject anEvent) {
                    return false;
                }
            };
            columnModel.getColumn(this.getVMTypeColumnIndex()).setCellEditor(typeEditor);
            this.fLengthSpinner = new EditableNumericCellSpinner();
            this.fLengthSpinner.setMax(this.getVMSize() - 1);
            this.fLengthSpinner.setMin(0);
            this.fLengthSpinner.setIncrement(1);
            SpinnerCellEditor addressCellEditor = new SpinnerCellEditor(this.fLengthSpinner);
            addressCellEditor.setClickCountToStart(2);
            this.fTablePanel.setCellEditor(this.getAddressColumnIndex(), addressCellEditor);
            this.fBlockMappingPanel.add(this.fTablePanel);
        }
        return this.fBlockMappingPanel;
    }

    private int getBlockColumnIndex() {
        return 0;
    }

    private int getParameterColumnIndex() {
        return 1;
    }

    private int getVMTypeColumnIndex() {
        return 2;
    }

    private int getAddressColumnIndex() {
        return 3;
    }

    public void loadFieldContents() throws ProgramException {
        BlockVMMappingInfo vmMapping = this.fLogoDrawing.getWiringDiagram().getBlockVMMappingInfo();
        Enumeration<BlockVMMappingInfo.Param2VMInfo> writeOperations = vmMapping.getMappingInfo().elements();
        while (writeOperations.hasMoreElements()) {
            BlockVMMappingInfo.Param2VMInfo info = writeOperations.nextElement();
            ParameterItem parameterItem = info.paramItem;
            Object[] rowData = new Object[]{parameterItem.getParameter().getBlock(), parameterItem, VMConfigurePanel.getVMTypeName(info.length), info.address};
            this.fTablePanel.addRowIntoJTable(-1, rowData);
        }
        if (this.fTable.getRowCount() < this.fHardware.getIntProperty("blockVMMappingNumber")) {
            this.fTablePanel.addRowIntoJTable(-1, null);
        }
    }

    public void storeFieldContents() {
        BlockVMMappingInfo vmMapping = this.fLogoDrawing.getWiringDiagram().getBlockVMMappingInfo();
        vmMapping.clear();
        for (int i = 0; i < this.fTable.getRowCount(); ++i) {
            ParameterItem parameterItem = (ParameterItem)this.fTable.getValueAt(i, this.getParameterColumnIndex());
            Object address = this.fTable.getValueAt(i, this.getAddressColumnIndex());
            Object vmType = this.fTable.getValueAt(i, this.getVMTypeColumnIndex());
            if (vmType == null || address == null || parameterItem == null) continue;
            vmMapping.addBlockVMMapping(parameterItem, Integer.valueOf(address.toString()));
        }
        this.fLogoDrawing.setModified(true);
    }

    public boolean checkFieldContents() {
        if (this.fTable.isEditing()) {
            this.fTable.getCellEditor().stopCellEditing();
        }
        for (int i = 0; i < this.fTable.getRowCount(); ++i) {
            Object block = this.fTable.getValueAt(i, this.getBlockColumnIndex());
            Object parameterItem = this.fTable.getValueAt(i, this.getParameterColumnIndex());
            Object address = this.fTable.getValueAt(i, this.getAddressColumnIndex());
            Object vmType = this.fTable.getValueAt(i, this.getVMTypeColumnIndex());
            if (block == null && parameterItem == null && vmType == null && address == null) continue;
            if (block == null || parameterItem == null || vmType == null || address == null) {
                Object[] info = new Object[]{i + 1};
                new LogoError(null, "tool.vmConfigure.emptyValue", "The value in line %" + (i + 1) + " must not be empty.", info, 0, 0).display();
                return false;
            }
            int maxAddress = this.getVMSize() - VMConfigurePanel.getDataTypeLength(vmType.toString());
            if (Integer.valueOf(address.toString()) <= maxAddress) continue;
            Object[] info = new Object[]{i + 1, vmType, maxAddress};
            new LogoError(null, "tool.vmConfigure.outofRange", "The start address for " + vmType + " in line " + (i + 1) + " must be smaller than " + maxAddress, info, 0, 0).display();
            return false;
        }
        return true;
    }

    private int getVMSize() {
        return this.fLogoDrawing.getWiringDiagram().getHardware().getIntProperty("nStartAddress");
    }

    public static int getDataTypeLength(String typeName) {
        if (typeName.equalsIgnoreCase("DWord")) {
            return 4;
        }
        if (typeName.equalsIgnoreCase("Word")) {
            return 2;
        }
        return 1;
    }

    public static String getVMTypeName(int length) {
        if (length == 1) {
            return "Byte";
        }
        if (length == 2) {
            return "Word";
        }
        if (length == 4) {
            return "DWord";
        }
        return "";
    }

    public class BlockTableCellRenderer
    extends DefaultTableCellRenderer {
        protected float fScale = 1.0f;
        private boolean fBlockNumberVisible;

        public BlockTableCellRenderer() {
        }

        public BlockTableCellRenderer(boolean blockNumberVisible) {
            this.fBlockNumberVisible = blockNumberVisible;
        }

        protected void setValue(Object value) {
            Block block = null;
            if (value instanceof Block) {
                block = (Block)value;
            } else if (value instanceof ParameterItem) {
                block = ((ParameterItem)value).getParameter().getBlock();
            } else if (value != null) {
                this.setText(value.toString());
                this.setIcon(null);
            } else {
                this.setText("");
                this.setIcon(null);
            }
            if (block != null) {
                this.setIcon(this.scaleIcon(Global.getIcon(block.getIconName())));
                String text = block.getLocalizedName(this.fBlockNumberVisible);
                if (value instanceof ParameterItem) {
                    this.setText(text + " - " + ((ParameterItem)value).getLocalisedName());
                } else {
                    this.setText(text);
                }
            }
        }

        protected Icon scaleIcon(ImageIcon orgIcon) {
            float scale = this.getScale();
            if (scale == 1.0f) {
                return orgIcon;
            }
            return new ImageIcon(orgIcon.getImage().getScaledInstance((int)((float)orgIcon.getIconWidth() * scale), (int)((float)orgIcon.getIconHeight() * scale), scale > 1.0f ? 2 : 4));
        }

        public float getScale() {
            return this.fScale;
        }

        public void setScale(float scale) {
            this.fScale = scale;
        }
    }

    public class ParameterItemListCellRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value == null) {
                return this;
            }
            ParameterItem parameterItem = (ParameterItem)value;
            this.setText(parameterItem.getLocalisedName());
            if (parameterItem instanceof UDFParameterItem) {
                parameterItem = ((UDFParameterItem)parameterItem).getRootSourceParameterItem();
            }
            ImageIcon icon = null;
            if (parameterItem.getParameterValueType() == 1 && !parameterItem.isEditableViaVM()) {
                icon = Global.getIcon("Refresh.gif");
            }
            if (parameterItem.getParameterValueType() == 1 && parameterItem.isEditableViaVM()) {
                icon = Global.getIcon("RefreshEditable.gif");
            }
            if (parameterItem.getParameterValueType() != 1 && parameterItem.isEditableViaVM()) {
                icon = Global.getIcon("Editable.gif");
            }
            if (parameterItem.getParameterValueType() == 2) {
                icon = Global.getIcon("Refresh.gif");
            }
            if (parameterItem.isEditableViaVM() && parameterItem.getValue() instanceof ValueOrItemReference && ((ValueOrItemReference)parameterItem.getValue()).isReference()) {
                icon = Global.getIcon("ReferencedParameter.gif");
            }
            if (parameterItem.getParameterValueType() == 3) {
                ParameterItem bindedParam = parameterItem.getParameter().getParameterItem(parameterItem.getMinWidth());
                if (bindedParam.isEditableViaVM() && bindedParam.getValue() instanceof ValueOrItemReference && ((ValueOrItemReference)bindedParam.getValue()).isReference()) {
                    icon = Global.getIcon("ReferencedParameter.gif");
                }
                if (bindedParam.isActualValue()) {
                    icon = Global.getIcon("Refresh.gif");
                }
            }
            this.setIcon(icon);
            return this;
        }
    }

    public class ParameterItemTableCellRenderer
    extends DefaultTableCellRenderer {
        protected void setValue(Object value) {
            if (value == null) {
                this.setText("");
                this.setIcon(null);
                return;
            }
            ParameterItem parameterItem = (ParameterItem)value;
            this.setText(parameterItem.getLocalisedName());
            if (parameterItem instanceof UDFParameterItem) {
                parameterItem = ((UDFParameterItem)parameterItem).getRootSourceParameterItem();
            }
            ImageIcon icon = null;
            if (parameterItem.getParameterValueType() == 1 && !parameterItem.isEditableViaVM()) {
                icon = Global.getIcon("Refresh.gif");
            }
            if (parameterItem.getParameterValueType() == 1 && parameterItem.isEditableViaVM()) {
                icon = Global.getIcon("RefreshEditable.gif");
            }
            if (parameterItem.getParameterValueType() != 1 && parameterItem.isEditableViaVM()) {
                icon = Global.getIcon("Editable.gif");
            }
            if (parameterItem.getParameterValueType() == 2) {
                icon = Global.getIcon("Refresh.gif");
            }
            if (parameterItem.isEditableViaVM() && parameterItem.getValue() instanceof ValueOrItemReference && ((ValueOrItemReference)parameterItem.getValue()).isReference()) {
                icon = Global.getIcon("ReferencedParameter.gif");
            }
            if (parameterItem.getParameterValueType() == 3) {
                ParameterItem bindedParam = parameterItem.getParameter().getParameterItem(parameterItem.getMinWidth());
                if (bindedParam.isEditableViaVM() && bindedParam.getValue() instanceof ValueOrItemReference && ((ValueOrItemReference)bindedParam.getValue()).isReference()) {
                    icon = Global.getIcon("ReferencedParameter.gif");
                }
                if (bindedParam.isActualValue()) {
                    icon = Global.getIcon("Refresh.gif");
                }
            }
            this.setIcon(icon);
        }
    }

    class ComboBoxSwitchTable
    extends JTable {
        public ComboBoxSwitchTable(AbstractTableModel model) {
            super(model);
        }

        public TableCellEditor getCellEditor(int row, int column) {
            if (column == VMConfigurePanel.this.getParameterColumnIndex()) {
                Block block = (Block)this.getValueAt(row, VMConfigurePanel.this.getBlockColumnIndex());
                Vector<ParameterItem> concreteParameterItems = new Vector<ParameterItem>();
                if (block != null) {
                    BlockParameter blockParameter = block.getParameter();
                    block0: for (ParameterItem parameterItem : blockParameter.getParameterItems().getPublicToVMParameterItemList()) {
                        concreteParameterItems.add(parameterItem.getInstanceForParameter(block.getParameter()));
                        if (!(parameterItem instanceof UDFParameterItem)) continue;
                        ParameterItem rootParaItem = ((UDFParameterItem)parameterItem).getRootSourceParameterItem();
                        for (ParameterItem item : rootParaItem.getParameter().getParameterItems()) {
                            if (item.getParameterValueType() != 3 || !rootParaItem.getParameter().getParameterItem(item.getMinWidth()).getIdentifier().equals(rootParaItem.getIdentifier())) continue;
                            concreteParameterItems.add(new UDFParameterItem((UDFBlockParameter)parameterItem.getParameter(), parameterItem.getIdentifier() + " " + Language.getString("dialog.parameter.stopwatch.timebase", "Time Base"), item.getInstanceForParameter(rootParaItem.getParameter()), 9));
                            continue block0;
                        }
                    }
                }
                VMConfigurePanel.this.fParameterJComboBox.setModel(new DefaultComboBoxModel(concreteParameterItems));
                VMConfigurePanel.this.fParameterJComboBox.repaint();
                DefaultCellEditor parameterCellEditor = new DefaultCellEditor(VMConfigurePanel.this.fParameterJComboBox);
                parameterCellEditor.setClickCountToStart(2);
                return parameterCellEditor;
            }
            return super.getCellEditor(row, column);
        }
    }
}

